# UPDATE VARIABLE
- Buka constants.php
- sesuaikan APP_URL
- isi APP_ENV dengan 'production'

# import .sql
- add_provider_to_tbl_pgate 
- add_hotspot_templates
- add_provider_to_tb_tagihan

# Sistem Billing L-ONE NETWORK

Aplikasi billing internet dengan fitur payment gateway multi-provider dan sistem template hotspot yang dapat dikustomisasi.

## 📋 Daftar Isi

- [Fitur Payment Gateway](#fitur-payment-gateway)
  - [Midtrans](#1-midtrans)
  - [Tripay](#2-tripay)
  - [Xendit](#3-xendit)
- [Sistem Template Hotspot](#sistem-template-hotspot)
- [Instalasi dan Konfigurasi](#instalasi-dan-konfigurasi)

---

## 🏦 Fitur Payment Gateway

Aplikasi ini mendukung 3 provider payment gateway yang dapat diaktifkan secara bergantian sesuai kebutuhan:

### 1. Midtrans

Midtrans adalah payment gateway Indonesia yang mendukung berbagai metode pembayaran seperti kartu kredit, e-wallet, bank transfer, dan convenience store.

#### Cara Mendapatkan API Keys Midtrans:

1. **Daftar Akun Midtrans**
   - Buka [https://midtrans.com](https://midtrans.com)
   - Klik "Daftar" dan lengkapi formulir pendaftaran
   - Verifikasi email dan nomor telepon
   - Upload dokumen bisnis yang diperlukan

2. **Akses Dashboard**
   - Login ke [dashboard Midtrans](https://dashboard.midtrans.com)
   - Pilih environment "Sandbox" untuk testing atau "Production" untuk live

3. **Mendapatkan API Keys**
   - Di dashboard, masuk ke menu **Settings → Access Keys**
   - Copy **Client Key** dan **Server Key**
   - Untuk production, pastikan akun sudah diverifikasi dan disetujui
   - Kunjungi https://dashboard.midtrans.com/settings/vtweb_configuration
     - Tambah Payment Notification URL*: `https://domain-anda.com/payment/notification-handler.php` 

4. **Konfigurasi di Aplikasi**
   - Masuk ke menu **Kelola Bank** di aplikasi
   - Pilih provider **"Midtrans"**
   - Masukkan:
     - **Client Key**: Paste client key dari dashboard Midtrans
     - **Server Key**: Paste server key dari dashboard Midtrans
     - **Merchant Code**: ID merchant dari dashboard (opsional)

#### Metode Pembayaran yang Didukung:
- Kartu Kredit (Visa, MasterCard, JCB)
- E-wallet (GoPay, OVO, Dana, LinkAja, ShopeePay)
- Bank Transfer (BCA, BNI, BRI, Mandiri, Permata)
- Convenience Store (Alfamart, Indomaret)
- Kredivo, Akulaku

---

### 2. Tripay

Tripay adalah payment gateway lokal Indonesia yang fokus pada kemudahan integrasi dengan biaya yang kompetitif.

#### Cara Mendapatkan API Keys Tripay:

1. **Daftar Akun Tripay**
   - Buka [https://tripay.co.id](https://tripay.co.id)
   - Klik "Daftar Merchant" 
   - Isi formulir pendaftaran dengan data bisnis
   - Verifikasi email dan nomor telepon

2. **Verifikasi Dokumen**
   - Upload KTP/NIK pemilik bisnis
   - Upload NPWP (jika ada)
   - Upload dokumen legalitas bisnis
   - Tunggu proses verifikasi (1-3 hari kerja)

3. **Akses Dashboard**
   - Login ke [dashboard Tripay](https://tripay.co.id/member)
   - Setelah akun diverifikasi, akses menu API

4. **Mendapatkan API Keys**
   - Di dashboard, masuk ke **Pengaturan → API Key**
   - Generate atau copy:
     - **Merchant Code**: Kode unik merchant Anda
     - **API Key**: Untuk authentifikasi request
     - **Private Key**: Untuk signature generation

5. **Konfigurasi di Aplikasi**
   - Masuk ke menu **Kelola Bank** di aplikasi
   - Pilih provider **"Tripay"**
   - Masukkan:
     - **Client Key**: Paste API Key dari dashboard Tripay
     - **Server Key**: Paste Private Key dari dashboard Tripay
     - **Merchant Code**: Paste Merchant Code dari dashboard

#### Metode Pembayaran yang Didukung:
- E-wallet (OVO, Dana, ShopeePay, LinkAja)
- Bank Transfer (BCA, BNI, BRI, Mandiri, BSI, CIMB)
- Virtual Account
- Convenience Store (Alfamart, Indomaret)
- QRIS

#### Fitur Pemilihan Metode Pembayaran:
Ketika provider Tripay aktif, sistem akan menampilkan pilihan metode pembayaran sebelum redirect ke halaman pembayaran Tripay. Pengguna dapat memilih dari 12 metode pembayaran yang tersedia:

1. **Virtual Account**: BRI, BNI, BCA, Mandiri, BSI (Biaya: Rp 4.000)
2. **Convenience Store**: Alfamart, Indomaret (Biaya: Rp 2.500)
3. **E-wallet**: OVO, DANA, ShopeePay, LinkAja (Gratis)
4. **QRIS**: Scan QR Code (Gratis)

Pemilihan metode akan disimpan ke database untuk tracking dan pelaporan.

---

### 3. Xendit

Xendit adalah payment gateway Asia Tenggara yang menyediakan solusi pembayaran lengkap untuk bisnis online.

#### Cara Mendapatkan API Keys Xendit:

1. **Daftar Akun Xendit**
   - Buka [https://xendit.co](https://xendit.co)
   - Klik "Sign Up" dan pilih negara Indonesia
   - Lengkapi formulir pendaftaran bisnis
   - Verifikasi email

2. **Verifikasi Bisnis**
   - Upload dokumen yang diperlukan:
     - KTP direktur/pemilik
     - NPWP perusahaan
     - Akta pendirian (untuk PT/CV)
     - Rekening bank bisnis
   - Tunggu proses verifikasi (3-7 hari kerja)

3. **Akses Dashboard**
   - Login ke [dashboard Xendit](https://dashboard.xendit.co)
   - Pilih environment "Test" untuk development atau "Live" untuk production

4. **Mendapatkan API Keys**
   - Di dashboard, masuk ke **Settings → API Keys**
   - Generate atau copy:
     - **Secret API Key**: Untuk server-side authentication
     - **Public API Key**: Untuk client-side (opsional)
     - **Webhook Token**: Untuk verifikasi callback

5. **Konfigurasi Webhook**
   - Di dashboard, masuk ke **Settings → Webhooks**
   - Tambah URL webhook: `https://domain-anda.com/payment/notification-handler.php`
   - Pilih yang invoices (lihat screenshot https://prnt.sc/BA-05w4C6NsJ)

6. **Konfigurasi di Aplikasi**
   - Masuk ke menu **Kelola Bank** di aplikasi
   - Pilih provider **"Xendit"**
   - Masukkan:
     - **Client Key**: Paste Secret API Key dari dashboard Xendit
     - **Webhook Token**: Paste Webhook Token untuk verifikasi callback

#### Metode Pembayaran yang Didukung:
- E-wallet (OVO, Dana, LinkAja, ShopeePay)
- Bank Transfer & Virtual Account (BCA, BNI, BRI, Mandiri, Permata)
- Credit Card (Visa, MasterCard)
- Convenience Store (Alfamart, Indomaret)
- QRIS

---

## ⚙️ Cara Menggunakan Payment Gateway

### Switching Provider
1. Masuk ke menu **Kelola Bank**
2. Pilih provider yang ingin diaktifkan dari dropdown
3. Pastikan semua API keys sudah diisi dengan benar
4. Klik **Simpan**
5. Sistem akan otomatis menggunakan provider yang dipilih untuk transaksi selanjutnya

### Testing Mode vs Production
- **Testing/Sandbox**: Gunakan untuk development dan testing
- **Production/Live**: Gunakan untuk transaksi real dengan uang asli

Pastikan environment yang benar sudah dikonfigurasi di file `constants.php`:
```php
define('APP_ENV', 'development'); // atau 'production'
```

---

## 🎫 Sistem Template Hotspot

Fitur ini memungkinkan admin untuk membuat dan mengelola template cetak tiket hotspot yang dapat dikustomisasi sepenuhnya.

### Fitur Template Hotspot:

1. **Multi-Template Support**: Buat template sebanyak yang diinginkan
2. **Active Template System**: Hanya satu template yang aktif dalam satu waktu
3. **Variable Replacement**: Konten dinamis dari data MikroTik
4. **Print Optimization**: Template dioptimalkan untuk pencetakan
5. **Professional Styling**: CSS styling yang responsif dan modern

### Cara Mengelola Template:

#### 1. Akses Management Template
- Login sebagai admin
- Masuk ke menu **Custom Pesan**
- Scroll ke bagian **"Template Hotspot Ticket"**

#### 2. Membuat Template Baru
1. **Isi Nama Template**: Berikan nama yang deskriptif (contoh: "Template Standar", "Template VIP")
2. **Tulis HTML Template**: Masukkan kode HTML dengan variable yang tersedia
3. **Centang "Set as Active"**: Jika ingin langsung mengaktifkan template ini
4. **Klik Simpan**: Template akan tersimpan dan siap digunakan

#### 3. Variable yang Tersedia

**Informasi Perusahaan:**
- `{{COMPANY_NAME}}` - Nama perusahaan/ISP
- `{{COMPANY_PHONE}}` - Nomor telepon perusahaan
- `{{COMPANY_WEBSITE}}` - Website perusahaan

**Informasi User:**
- `{{USER_NAME}}` - Nama user hotspot
- `{{USERNAME}}` - Username untuk login
- `{{PASSWORD}}` - Password untuk login
- `{{USER_PROFILE}}` - Profil/paket user
- `{{COMMENT}}` - Komentar/catatan user

**Tanggal & Waktu:**
- `{{CREATED_DATE}}` - Tanggal user dibuat
- `{{CURRENT_DATE}}` - Tanggal saat ini
- `{{CURRENT_TIME}}` - Waktu saat ini

**Limit & Server:**
- `{{LIMIT_BYTES}}` - Limit data dalam format yang mudah dibaca
- `{{LIMIT_UPTIME}}` - Limit waktu
- `{{SERVER_NAME}}` - Nama server hotspot

#### 4. Contoh Template HTML

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Tiket WiFi Hotspot</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .ticket {
            width: 350px;
            margin: 0 auto;
            border: 2px solid #333;
            padding: 15px;
        }
        .header {
            text-align: center;
            border-bottom: 1px solid #333;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        .credentials {
            background: #e8f4fd;
            padding: 10px;
            margin: 15px 0;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="header">
            <h2>{{COMPANY_NAME}}</h2>
            <h3>TIKET WIFI HOTSPOT</h3>
        </div>
        
        <div class="user-info">
            <p><strong>Nama:</strong> {{USER_NAME}}</p>
            <p><strong>Paket:</strong> {{USER_PROFILE}}</p>
            <p><strong>Limit Data:</strong> {{LIMIT_BYTES}}</p>
            <p><strong>Limit Waktu:</strong> {{LIMIT_UPTIME}}</p>
        </div>
        
        <div class="credentials">
            <p><strong>Username: {{USERNAME}}</strong></p>
            <p><strong>Password: {{PASSWORD}}</strong></p>
        </div>
        
        <div class="footer">
            <p>Terima kasih telah menggunakan layanan kami</p>
            <p>Support: {{COMPANY_PHONE}}</p>
        </div>
    </div>
</body>
</html>
```

### Cara Mencetak Tiket:

#### 1. Akses Halaman Users Hotspot
- Masuk ke menu **Hotspot → Users Hotspot**
- Akan muncul tabel dengan daftar semua user hotspot

#### 2. Cetak Tiket Individual
1. Cari user yang ingin dicetak tiketnya
2. Klik tombol **"Print"** (ikon printer) di kolom paling kanan
3. Akan terbuka window baru dengan preview tiket
4. Tiket akan otomatis ter-print atau bisa di-save sebagai PDF

#### 3. Fitur Print
- **Auto Print**: Halaman akan otomatis membuka dialog print
- **Print Preview**: Dapat melihat hasil sebelum print
- **Save as PDF**: Dapat menyimpan tiket sebagai file PDF
- **Responsive**: Template akan menyesuaikan ukuran kertas

### Tips Penggunaan Template:

1. **Ukuran Kertas**: Disarankan menggunakan ukuran A6 atau custom size untuk tiket
2. **Font Size**: Gunakan font size 10-14px untuk keterbacaan optimal
3. **Logo**: Tambahkan logo perusahaan dengan tag `<img>` di header
4. **QR Code**: Bisa menambahkan QR code untuk autentikasi tambahan
5. **Styling**: Gunakan CSS internal untuk styling yang konsisten

### Troubleshooting:

**Template tidak muncul saat print:**
- Pastikan ada template yang aktif
- Cek koneksi ke MikroTik server
- Pastikan user exists di MikroTik

**Variable tidak ter-replace:**
- Pastikan penulisan variable dengan format `{{VARIABLE_NAME}}`
- Case sensitive, gunakan huruf besar
- Cek koneksi RouterOS API

**Print tidak bekerja:**
- Pastikan browser memiliki permission untuk print
- Cek popup blocker tidak memblok window print
- Gunakan browser modern (Chrome, Firefox, Edge)

---

## 🚀 Instalasi dan Konfigurasi

### Persyaratan Sistem:
- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Apache/Nginx web server
- Composer (untuk dependencies)
- Koneksi internet untuk API payment gateway

### Langkah Instalasi:

1. **Clone/Download** aplikasi ke directory web server
2. **Import Database**: Jalankan semua file SQL di folder `database/`
3. **Install Dependencies**: Jalankan `composer install` di terminal
4. **Konfigurasi Database**: Edit file `include/koneksi.php`
5. **Konfigurasi Environment**: Edit file `constants.php`
6. **Set Permissions**: Pastikan folder writable untuk uploads
7. **Test Connection**: Akses aplikasi melalui browser

### Konfigurasi MikroTik:
- Pastikan RouterOS API diaktifkan
- Buat user API dengan privilege yang sesuai
- Konfigurasi koneksi di menu pengaturan aplikasi

---

## 📞 Support

Untuk bantuan teknis atau pertanyaan terkait implementasi:
- **Email**: support@l-one.network
- **Phone**: +62-XXX-XXX-XXXX
- **Website**: www.l-one.network

---

## 📝 Changelog

### v2.1.0 (2025-08-25)
- ✅ Implementasi pemilihan metode pembayaran Tripay
- ✅ Interface pilihan channel pembayaran sebelum redirect
- ✅ Dukungan untuk 12 metode pembayaran Tripay
- ✅ Tracking payment channel di database
- ✅ UI responsif untuk pemilihan metode pembayaran

### v2.0.0 (2025-08-25)
- ✅ Implementasi multi-provider payment gateway (Midtrans, Tripay, Xendit)
- ✅ Sistem template hotspot yang dapat dikustomisasi
- ✅ Interface management template di custom pesan
- ✅ Print system dengan variable replacement
- ✅ Database migration untuk template system

### v1.0.0
- Fitur billing dasar
- Integrasi MikroTik RouterOS
- Management pelanggan dan pembayaran

---

## 📄 License

Copyright © 2025 L-ONE NETWORK. All rights reserved.
