<?php
// test_mikrotik_vpn.php
require_once('include/routeros_api.php');

echo "<h2>🧪 Testing MikroTik API via VPN</h2>";

$API = new RouterosAPI();
$API->debug = true;

// Your VPN connection details
$host = 'sg-08.tunnel.web.id';  // Hostname tanpa port
$username = 'admin';
$password = 'admin';
$api_port = 1048;             // API port yang berbeda

// Set connection parameters
$API->port = $api_port;
$API->ssl = false;
$API->timeout = 50;  // Timeout lebih lama untuk VPN

if ($API->connect($host, $username, $password)) {
  echo "</pre>";
  echo "<div style='color: green; font-size: 20px; font-weight: bold; text-align: center; padding: 15px; background: #d4edda; border: 1px solid #c3e6cb;'>";
  echo "🎉 CONNECTION SUCCESSFUL! 🎉";
  echo "</div>";

  try {
    // Test 1: System Identity
    echo "<div style='background: #f8f9fa; padding: 15px; margin: 10px 0; border: 1px solid #dee2e6;'>";
    echo "<h4>📋 System Identity</h4>";
    $identity = $API->comm("/system/identity/print");
    if ($identity && isset($identity[0]['name'])) {
      echo "Router Name: <strong style='color: #0066cc;'>" . $identity[0]['name'] . "</strong><br>";
    } else {
      echo "<span style='color: #666;'>Could not retrieve router name</span><br>";
    }
    echo "</div>";

    // Test 2: System Resource
    echo "<div style='background: #f8f9fa; padding: 15px; margin: 10px 0; border: 1px solid #dee2e6;'>";
    echo "<h4>💻 System Resource</h4>";
    $resource = $API->comm("/system/resource/print");
    if ($resource && isset($resource[0])) {
      echo "CPU Load: <strong>" . ($resource[0]['cpu-load'] ?? 'N/A') . "%</strong><br>";
      echo "Free Memory: <strong>" . formatBytes($resource[0]['free-memory'] ?? 0) . "</strong><br>";
      echo "Total Memory: <strong>" . formatBytes($resource[0]['total-memory'] ?? 0) . "</strong><br>";
      echo "Uptime: <strong>" . ($resource[0]['uptime'] ?? 'N/A') . "</strong><br>";
      echo "Version: <strong>" . ($resource[0]['version'] ?? 'N/A') . "</strong><br>";
      echo "Architecture: <strong>" . ($resource[0]['architecture-name'] ?? 'N/A') . "</strong><br>";
    } else {
      echo "<span style='color: #666;'>Could not retrieve system resource info</span><br>";
    }
    echo "</div>";

    // Test 3: API Service Status
    echo "<div style='background: #f8f9fa; padding: 15px; margin: 10px 0; border: 1px solid #dee2e6;'>";
    echo "<h4>🔧 Services Status</h4>";
    $services = $API->comm("/ip/service/print");
    $api_services = ['api', 'api-ssl', 'winbox', 'www'];

    foreach ($services as $service) {
      if (in_array($service['name'], $api_services)) {
        $status = ($service['disabled'] == 'true') ? '❌ Disabled' : '✅ Enabled';
        $color = ($service['disabled'] == 'true') ? 'red' : 'green';
        echo "<span style='color: $color;'>{$service['name']}</span> (Port: {$service['port']}): <strong>$status</strong><br>";
      }
    }
    echo "</div>";

    // Test 4: Hotspot Information
    echo "<div style='background: #f8f9fa; padding: 15px; margin: 10px 0; border: 1px solid #dee2e6;'>";
    echo "<h4>🌐 Hotspot Information</h4>";

    $hotspots = $API->comm("/ip/hotspot/print");
    echo "Hotspot Servers: <strong style='color: #0066cc;'>" . count($hotspots) . "</strong><br>";

    $users = $API->comm("/ip/hotspot/user/print");
    echo "Hotspot Users: <strong style='color: #0066cc;'>" . count($users) . "</strong><br>";

    $profiles = $API->comm("/ip/hotspot/user/profile/print");
    echo "User Profiles: <strong style='color: #0066cc;'>" . count($profiles) . "</strong><br>";

    $active = $API->comm("/ip/hotspot/active/print");
    echo "Active Users: <strong style='color: #28a745;'>" . count($active) . "</strong><br>";
    echo "</div>";

    // Test 5: Interface Status
    echo "<div style='background: #f8f9fa; padding: 15px; margin: 10px 0; border: 1px solid #dee2e6;'>";
    echo "<h4>🔌 Interface Status</h4>";
    $interfaces = $API->comm("/interface/print");
    $interface_count = 0;
    foreach ($interfaces as $iface) {
      if ($interface_count < 5) { // Show first 5 interfaces
        $status = ($iface['disabled'] == 'true') ? '❌' : '✅';
        echo "$status {$iface['name']} ({$iface['type']})<br>";
        $interface_count++;
      }
    }
    if (count($interfaces) > 5) {
      echo "<small>... and " . (count($interfaces) - 5) . " more interfaces</small><br>";
    }
    echo "</div>";
  } catch (Exception $e) {
    echo "<div style='color: red; background: #f8d7da; padding: 15px; border: 1px solid #f5c6cb;'>";
    echo "❌ <strong>Error executing commands:</strong> " . $e->getMessage();
    echo "</div>";
  }

  $API->disconnect();
  echo "<div style='color: blue; font-weight: bold; text-align: center; padding: 10px;'>";
  echo "🔌 Disconnected Successfully";
  echo "</div>";
} else {
  echo "</pre>";
  echo "<div style='color: red; font-size: 18px; font-weight: bold; text-align: center; padding: 15px; background: #f8d7da; border: 1px solid #f5c6cb;'>";
  echo "❌ CONNECTION FAILED!";
  echo "</div>";

  echo "<div style='background: #fff3cd; padding: 15px; margin: 15px 0; border: 1px solid #ffeaa7;'>";
  echo "<strong>🔍 Error Details:</strong><br>";
  echo "Error Number: " . ($API->error_no ?? 'N/A') . "<br>";
  echo "Error Message: " . ($API->error_str ?? 'N/A') . "<br>";
  echo "</div>";

  echo "<div style='background: #d1ecf1; padding: 15px; margin: 15px 0; border: 1px solid #bee5eb;'>";
  echo "<strong>💡 VPN Troubleshooting Tips:</strong><br>";
  echo "1. <strong>Check VPN Connection:</strong> Pastikan VPN aktif dan stabil<br>";
  echo "2. <strong>Verify API Service:</strong> Di MikroTik, pastikan IP → Services → API enabled pada port 1769<br>";
  echo "3. <strong>Check Firewall:</strong> Pastikan port 1769 tidak diblok firewall<br>";
  echo "4. <strong>Test in Winbox:</strong> Coba akses Terminal di Winbox dan jalankan: <code>/ip service print</code><br>";
  echo "5. <strong>User Permissions:</strong> User 'admin' harus punya policy 'api' aktif<br>";
  echo "6. <strong>Network Latency:</strong> VPN bisa menyebabkan timeout, coba increase timeout<br>";
  echo "</div>";
}

function formatBytes($bytes)
{
  if ($bytes == 0) return '0 B';
  $units = array('B', 'KB', 'MB', 'GB', 'TB');
  $bytes = max($bytes, 0);
  $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
  $pow = min($pow, count($units) - 1);
  $bytes /= pow(1024, $pow);
  return round($bytes, 2) . ' ' . $units[$pow];
}
