<?php
// Payment Status Checker - can be used as cron job or manual check
include('include/koneksi.php');
require_once 'payment/PaymentGatewayFactory.php';

// Get payment gateway configuration
$queryP = $koneksi->query("SELECT * FROM tbl_pgate LIMIT 1");
$tokenP = $queryP->fetch_assoc();

if (!$tokenP || empty($tokenP['provider'])) {
  echo "Payment gateway not configured\n";
  exit;
}

$provider = $tokenP['provider'];

// Check pending transactions
$sqlPending = $koneksi->query("SELECT * FROM tb_tagihan WHERE status_bayar = 0 AND payment_order_id IS NOT NULL");

if ($sqlPending->num_rows > 0) {
  echo "Checking " . $sqlPending->num_rows . " pending transactions...\n";

  while ($transaction = $sqlPending->fetch_assoc()) {
    $orderId = $transaction['payment_order_id'];

    try {
      // Check transaction status based on provider
      $status = checkTransactionStatus($provider, $tokenP, $orderId);

      if ($status === 'settlement' || $status === 'paid') {
        // Process settlement
        processSettlement($koneksi, $transaction['id_tagihan'], $orderId);
        echo "Transaction $orderId settled\n";
      } elseif ($status === 'expire' || $status === 'failed') {
        // Mark as expired/failed
        $koneksi->query("UPDATE tb_tagihan SET payment_status='failed' WHERE id_tagihan='{$transaction['id_tagihan']}'");
        echo "Transaction $orderId marked as failed\n";
      }
    } catch (Exception $e) {
      echo "Error checking transaction $orderId: " . $e->getMessage() . "\n";
    }

    // Add delay to avoid rate limiting
    sleep(1);
  }
} else {
  echo "No pending transactions found\n";
}

function checkTransactionStatus($provider, $config, $orderId)
{
  switch ($provider) {
    case 'midtrans':
      return checkMidtransStatus($config, $orderId);
    case 'tripay':
      return checkTripayStatus($config, $orderId);
    case 'xendit':
      return checkXenditStatus($config, $orderId);
    default:
      throw new Exception("Unsupported provider: $provider");
  }
}

function checkMidtransStatus($config, $orderId)
{
  $serverKey = $config['tserverkey'];
  $url = "https://api.midtrans.com/v2/$orderId/status";

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      'Authorization: Basic ' . base64_encode($serverKey . ':'),
      'Content-Type: application/json',
    ],
  ]);

  $response = curl_exec($curl);
  curl_close($curl);

  $data = json_decode($response, true);
  return $data['transaction_status'] ?? 'unknown';
}

function checkTripayStatus($config, $orderId)
{
  $apiKey = $config['tclientkey'];
  $url = "https://tripay.co.id/api/transaction/detail?reference=$orderId";

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      'Authorization: Bearer ' . $apiKey,
    ],
  ]);

  $response = curl_exec($curl);
  curl_close($curl);

  $data = json_decode($response, true);
  return $data['data']['status'] ?? 'unknown';
}

function checkXenditStatus($config, $orderId)
{
  $apiKey = $config['tclientkey'];
  $url = "https://api.xendit.co/v2/invoices?external_id=$orderId";

  $curl = curl_init();
  curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      'Authorization: Basic ' . base64_encode($apiKey . ':'),
    ],
  ]);

  $response = curl_exec($curl);
  curl_close($curl);

  $data = json_decode($response, true);
  if (!empty($data['data']) && count($data['data']) > 0) {
    $status = $data['data'][0]['status'];
    // Map Xendit status to common status
    $statusMap = [
      'PAID' => 'settlement',
      'PENDING' => 'pending',
      'EXPIRED' => 'expire',
      'FAILED' => 'failed'
    ];
    return $statusMap[$status] ?? 'unknown';
  }
  return 'unknown';
}

function processSettlement($koneksi, $idTagihan, $orderId)
{
  // Include the same settlement logic from notification-handler.php
  // This is a simplified version - you may want to extract the settlement logic to a separate function

  $tglBayar = date('Y-m-d');

  // Get invoice number
  $sql = $koneksi->query("SELECT no_invoice FROM tb_tagihan ORDER BY no_invoice DESC LIMIT 1");
  $data = $sql->fetch_assoc();
  $no_spt = $data['no_invoice'] ?? '00000.BLR.MST.';
  $urut = substr($no_spt, 0, 5);
  $tambah = (int) $urut + 1;
  $format = str_pad($tambah, 5, '0', STR_PAD_LEFT) . '.BLR.MST.';

  // Update tagihan
  $koneksi->query("UPDATE tb_tagihan SET 
        status_bayar=1, 
        tgl_bayar='$tglBayar', 
        no_invoice='$format', 
        waktu_bayar=NOW(),
        payment_status='settled'
        WHERE id_tagihan='$idTagihan'");

  // Additional processing (kas, notification, etc.) can be added here
}
