<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>Hotspot User Ticket</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      font-size: 12px;
      margin: 0;
      padding: 20px;
      background: white;
    }

    .ticket {
      /* width: 350px; */
      margin: 0 auto;
      border: 2px solid #333;
      padding: 15px;
      background: #f9f9f9;
    }

    /* Grid layout styles for print all tickets */
    .ticket-page {
      page-break-after: always;
      display: block;
      width: 100%;
      padding: 5px;
      box-sizing: border-box;
      min-height: 100vh;
    }

    .ticket-row {
      display: flex;
      width: 100%;
      margin-bottom: 5px;
      box-sizing: border-box;
    }

    .ticket-cell {
      width: 25%;
      /* Exactly 25% for 4 columns */
      border: 1px solid #333;
      margin: 1px;
      padding: 5px;
      box-sizing: border-box;
      font-size: 8px;
      background: #f9f9f9;
      overflow: hidden;
      min-height: 200px;
      /* Minimum height for each ticket */
    }

    .ticket-cell.empty-cell {
      border: none;
      background: transparent;
    }

    .ticket-cell .header {
      text-align: center;
      border-bottom: 1px solid #333;
      padding-bottom: 3px;
      margin-bottom: 5px;
    }

    .ticket-cell .logo {
      max-width: 30px;
      margin-bottom: 2px;
    }

    .ticket-cell .company-name {
      font-size: 8px;
      font-weight: bold;
      margin: 2px 0;
    }

    .ticket-cell .title {
      font-size: 7px;
      font-weight: bold;
      margin: 3px 0;
    }

    .ticket-cell .user-info {
      margin: 5px 0;
      font-size: 7px;
    }

    .ticket-cell table {
      width: 100%;
      font-size: 7px;
    }

    .ticket-cell td,
    .ticket-cell th {
      padding: 1px 2px;
      font-size: 7px;
    }

    .header {
      text-align: center;
      border-bottom: 1px solid #333;
      padding-bottom: 10px;
      margin-bottom: 15px;
    }

    .logo {
      max-width: 80px;
      margin-bottom: 5px;
    }

    .company-name {
      font-size: 16px;
      font-weight: bold;
      margin: 5px 0;
    }

    .title {
      font-size: 14px;
      font-weight: bold;
      margin: 10px 0;
    }

    .user-info {
      margin: 15px 0;
    }

    .info-row {
      display: flex;
      justify-content: space-between;
      margin: 5px 0;
      border-bottom: 1px dotted #ccc;
      padding-bottom: 3px;
    }

    .label {
      font-weight: bold;
    }

    .credentials {
      background: #e8f4fd;
      padding: 10px;
      margin: 15px 0;
      border: 1px solid #b8daff;
      text-align: center;
    }

    .username,
    .password {
      font-size: 11px;
      font-weight: bold;
      margin: 5px 0;
    }

    .footer {
      text-align: center;
      margin-top: 15px;
      padding-top: 10px;
      border-top: 1px solid #333;
      font-size: 10px;
    }

    .qr-code {
      text-align: center;
      margin: 10px 0;
    }

    @media print {
      body {
        margin: 0;
        padding: 0;
      }

      .ticket {
        border: none;
        box-shadow: none;
      }
    }
  </style>
</head>

<body>

  <!-- Render Template Here -->

  <!-- End Render Template Here -->

  <script>
    // Auto print when page loads
    window.onload = function() {
      window.print();
    }
  </script>
</body>

</html>