<?php
session_start();
require_once __DIR__ . '/../../../constants.php';
if (isset($_SESSION['admin']) || $_SESSION['teknisi'] == true) {
?>

  <?php
  $sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
  $result = mysqli_query($koneksi, $sql_mikrotik);
  $row = mysqli_fetch_assoc($result);

  $API = new RouterosAPI();

  if ($API->connect($row['ip'], $row['username'], $row['password'])) {

    $getprofile = $API->comm("/ip/hotspot/user/profile/print");
    $srvlist = $API->comm("/ip/hotspot/print");

  ?>

    <div class="row">

      <div class="col-md-8">
        <!-- Advanced Tables -->
        <div class="box box-primary box-solid">
          <div class="box-header with-border">
            Generate Multiple Users
          </div>
          <div class="panel-body">
            <form method="POST" action="?page=users-hotspot&aksi=process_generate_users">
              <div class="form-group row">
                <label for="servers" class="col-sm-2 col-form-label">Servers</label>
                <div class="col-sm-10">
                  <select class="form-control" name="server" id="servers">
                    <option value="all">all</option>
                    <?php foreach ($srvlist as $q) : ?>
                      <option value="<?= $q['name'] ?>"><?= $q['name'] ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>
              </div>
              <div class="form-group row">
                <label class="col-sm-2 col-form-label">Username Prefix</label>
                <div class="col-sm-10">
                  <input type="text" name="username_prefix" class="form-control" placeholder="user" required>
                  <small class="form-text text-muted">Users will be named: prefix001, prefix002, etc.</small>
                </div>
              </div>
              <div class="form-group row">
                <label class="col-sm-2 col-form-label">Password Type</label>
                <div class="col-sm-10">
                  <select class="form-control" name="password_type" id="password_type" onchange="togglePasswordOptions()">
                    <option value="auto">Auto Generate</option>
                    <option value="same">Same for All</option>
                    <option value="username">Same as Username</option>
                  </select>
                </div>
              </div>
              <div class="form-group row" id="password_field" style="display: none;">
                <label class="col-sm-2 col-form-label">Password</label>
                <div class="col-sm-10">
                  <input type="text" name="password" class="form-control">
                </div>
              </div>
              <div class="form-group row">
                <label for="profile" class="col-sm-2 col-form-label">Profile</label>
                <div class="col-sm-10">
                  <select class="form-control" name="profile" id="profile" required>
                    <?php foreach ($getprofile as $g) : ?>
                      <option value="<?= $g['name'] ?>"><?= $g['name'] ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>
              </div>
              <div class="form-group row">
                <label class="col-sm-2 col-form-label">Time Limit</label>
                <div class="col-sm-10">
                  <input type="text" name="time_limit" class="form-control" placeholder="00:00:00">
                  <small class="form-text text-muted">Leave empty for unlimited</small>
                </div>
              </div>

              <!-- <div class="form-group row">
                <label class="col-sm-2 col-form-label">Data Limit</label>
                <div class="col-sm-8">
                  <input type="text" name="data_limit" class="form-control" placeholder="Leave empty for unlimited">
                </div>
                <div class="col-sm-2">
                  <select class="form-control" name="data_unit">
                    <option value="MB">MB</option>
                    <option value="GB">GB</option>
                  </select>
                </div>
              </div>

              <div class="form-group row">
                <label class="col-sm-2 col-form-label">Comment</label>
                <div class="col-sm-10">
                  <input type="text" name="comment" class="form-control" placeholder="Bulk generated users">
                </div>
              </div> -->

              <div class="form-group row">
                <label class="col-sm-2 col-form-label">Total Users</label>
                <div class="col-sm-10">
                  <input type="number" name="total_users" class="form-control"
                    <?= APP_ENV !== 'production' ? '' : 'min="1" max="1000"' ?>
                    value="1"
                    required>
                  <small class="form-text text-muted">Minimum 1 users, Maximum 1000 users at once</small>
                </div>
              </div>

              <div class="form-group row">
                <div class="col-sm-10 offset-sm-2">
                  <button type="submit" class="btn btn-primary">
                    <i class="fa fa-users"></i> Generate Users
                  </button>
                  <a href="?page=users-hotspot" class="btn btn-secondary">Cancel</a>
                </div>
              </div>
            </form>

          </div>
        </div>
      </div>

      <div class="col-md-4">
        <!-- Advanced Tables -->
        <div class="box box-primary box-solid">
          <div class="box-header with-border">
            Generation Guidelines
          </div>
          <div class="panel-body">
            <li><b>Username Naming</b></li>
            <li style="margin-left: 20px; list-style-type: none; text-align: justify;">
              Users will be named with prefix + sequential number (001, 002, etc.)
            </li>

            <li><b>Password Options</b></li>
            <li style="margin-left: 20px; list-style-type: none; text-align: justify;">
              Auto Generate: Random 6-character passwords<br>
              Same for All: Use one password for all users<br>
              Same as Username: Password equals username
            </li>

            <li><b>Format Time Limit</b></li>
            <li style="margin-left: 20px; list-style-type: none; text-align: justify;">
              Seperti Format yang ada di mikrotik Contoh 03:00:00 Untuk 3 Jam atau 1d 00:00:00 Untuk 1 Hari
            </li>

            <li><b>Data Limit</b></li>
            <li style="margin-left: 20px; list-style-type: none; text-align: justify;">
              Enter numeric value only. Select MB or GB from dropdown.
            </li>

          </div>
        </div>
      </div>

    </div>

    <script>
      function togglePasswordOptions() {
        var passwordType = document.getElementById('password_type').value;
        var passwordField = document.getElementById('password_field');

        if (passwordType === 'same') {
          passwordField.style.display = 'flex';
          document.querySelector('input[name="password"]').required = true;
        } else {
          passwordField.style.display = 'none';
          document.querySelector('input[name="password"]').required = false;
        }
      }

      // Initialize on page load
      document.addEventListener('DOMContentLoaded', function() {
        togglePasswordOptions();
      });
    </script>

    <style>
      .form-text {
        font-size: 0.875em;
        color: #6c757d;
      }

      .alert {
        padding: 0.75rem 1.25rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 0.25rem;
      }

      .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
      }

      .offset-sm-2 {
        margin-left: 16.666667%;
      }
    </style>

  <?php }
  $API->disconnect();
  ?>

<?php
} else {
  echo "Anda Tidak Berhak Mengakses Halaman Ini";
}
?>