<?php
session_start();
require_once __DIR__ . '/../../../constants.php';
if (isset($_SESSION['admin']) || $_SESSION['teknisi'] == true) {

  if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Get form data
    $server = $_POST['server'] ?? 'all';
    $username_prefix = $_POST['username_prefix'] ?? 'user';
    $password_type = $_POST['password_type'] ?? 'auto';
    $password = $_POST['password'] ?? '';
    $profile = $_POST['profile'] ?? '';
    $time_limit = $_POST['time_limit'] ?? '';
    $data_limit = $_POST['data_limit'] ?? '';
    $data_unit = $_POST['data_unit'] ?? 'MB';
    $comment = $_POST['comment'] ?? 'Bulk generated users';
    $total_users = (int)($_POST['total_users'] ?? 10);

    // Validate total users
    if (APP_ENV !== 'production') {
      if ($total_users < 1 || $total_users > 100) {
        $total_users = 2;
      }
    } else {
      if ($total_users < 1 || $total_users > 1000) {
        $total_users = 0;
      }
    }

    // Connect to MikroTik
    $sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
    $result = mysqli_query($koneksi, $sql_mikrotik);
    $row = mysqli_fetch_assoc($result);

    $API = new RouterosAPI();
    $generated_users = [];
    $errors = [];

    if ($API->connect($row['ip'], $row['username'], $row['password'])) {

      // Function to generate random password
      function generateRandomPassword($length = 6)
      {
        $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $password = '';
        for ($i = 0; $i < $length; $i++) {
          $password .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $password;
      }

      function generateUniqueUsernames($length, $count)
      {
        $pool = range(0, pow(10, $length) - 1); // semua kemungkinan angka
        shuffle($pool); // acak pool

        $result = [];
        for ($i = 0; $i < $count; $i++) {
          $result[] = str_pad($pool[$i], $length, "0", STR_PAD_LEFT);
        }
        return $result;
      }

      $usernames = generateUniqueUsernames(6, $total_users);

      // Generate users
      for ($i = 1; $i <= $total_users; $i++) {
        $username = $username_prefix . $usernames[$i - 1];

        // Determine password
        switch ($password_type) {
          case 'same':
            $user_password = $password;
            break;
          case 'username':
            $user_password = $username;
            break;
          case 'auto':
          default:
            $user_password = generateRandomPassword();
            break;
        }

        // Prepare data limit
        $data_limit_value = '';
        if (!empty($data_limit) && is_numeric($data_limit)) {
          $data_limit_value = $data_limit . $data_unit;
        }

        try {
          // langsung pake comm
          $params = [
            'name'     => $username,
            'password' => $user_password,
            'profile'  => $profile,
          ];

          if ($server !== 'all') {
            $params['server'] = $server;
          }

          if (!empty($time_limit)) {
            $params['limit-uptime'] = $time_limit;
          }

          if (!empty($data_limit_value)) {
            $params['limit-bytes-total'] = $data_limit_value;
          }

          if (!empty($comment)) {
            $params['comment'] = $comment;
          }

          $response = $API->comm('/ip/hotspot/user/add', $params);

          // Check if user was created successfully
          if (empty($response) || !isset($response[0]['!trap'])) {
            $generated_users[] = [
              'username'   => $username,
              'password'   => $user_password,
              'profile'    => $profile,
              'server'     => $server,
              'time_limit' => $time_limit,
              'data_limit' => $data_limit_value,
              'comment'    => $comment
            ];
          } else {
            $errors[] = "Failed to create user: " . $username . " - " . ($response[0]['message'] ?? 'Unknown error');
          }
        } catch (Exception $e) {
          $errors[] = "Error creating user: " . $username . " - " . $e->getMessage();
        }
      }

      $API->disconnect();

      // Store generated users in session for printing
      $_SESSION['generated_users'] = $generated_users;
    } else {
      $errors[] = "Failed to connect to MikroTik router";
    }
  }
?>

  <div class="row">
    <div class="col-md-12">
      <div class="box box-primary box-solid">
        <div class="box-header with-border">
          <b>User Generation Results</b>
        </div>
        <div class="panel-body">

          <?php if (!empty($errors)): ?>
            <div class="alert alert-warning">
              <h4><i class="fa fa-warning"></i> Warnings/Errors:</h4>
              <?php foreach ($errors as $error): ?>
                <p><?= htmlspecialchars($error) ?></p>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>

          <?php if (!empty($generated_users)): ?>
            <div class="alert alert-success">
              <h4><i class="fa fa-check"></i> Success!</h4>
              Successfully generated <?= count($generated_users) ?> users.
            </div>

            <div class="row mb-3">
              <div class="col-md-12">
                <button class="btn btn-primary" onclick="printAllUsers()">
                  <i class="fa fa-print"></i> Print All Generated Users
                </button>
                <a href="?page=users-hotspot" class="btn btn-secondary">
                  <i class="fa fa-arrow-left"></i> Back to Users List
                </a>
                <button class="btn btn-info" onclick="window.open('page/hotspot/users_hotspot/export_csv.php', '_blank')">
                  <i class="fa fa-download"></i> Export to CSV
                </button>
              </div>
            </div>

            <div class="table-responsive">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th>No</th>
                    <th>Username</th>
                    <th>Password</th>
                    <th>Profile</th>
                    <th>Server</th>
                    <th>Time Limit</th>
                    <th>Data Limit</th>
                    <th>Comment</th>
                    <th>Print</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($generated_users as $index => $user): ?>
                    <tr>
                      <td><?= $index + 1 ?></td>
                      <td><?= htmlspecialchars($user['username']) ?></td>
                      <td><?= htmlspecialchars($user['password']) ?></td>
                      <td><?= htmlspecialchars($user['profile']) ?></td>
                      <td><?= htmlspecialchars($user['server']) ?></td>
                      <td><?= htmlspecialchars($user['time_limit'] ?: 'Unlimited') ?></td>
                      <td><?= htmlspecialchars($user['data_limit'] ?: 'Unlimited') ?></td>
                      <td><?= htmlspecialchars($user['comment']) ?></td>
                      <td>
                        <button class="btn btn-xs btn-success" onclick="printTicket('<?= htmlspecialchars($user['username']) ?>')" title="Print Ticket">
                          <i class='fa fa-print'></i>
                        </button>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>

          <?php else: ?>
            <div class="alert alert-danger">
              <h4><i class="fa fa-times"></i> Error!</h4>
              No users were generated. Please check the errors above and try again.
            </div>
            <a href="?page=users-hotspot&aksi=generate_users" class="btn btn-primary">
              <i class="fa fa-arrow-left"></i> Try Again
            </a>
          <?php endif; ?>

        </div>
      </div>
    </div>
  </div>

  <script>
    function printTicket(username) {
      // Open print page in new window
      var printWindow = window.open(
        'page/hotspot/print_ticket.php?username=' + encodeURIComponent(username),
        'printTicket',
        'width=400,height=600,scrollbars=yes,resizable=yes'
      );

      // Focus on the new window
      if (printWindow) {
        printWindow.focus();
      }
    }

    function printAllUsers() {
      // Get all usernames from the table
      var usernames = [];
      <?php if (!empty($generated_users)): ?>
        <?php foreach ($generated_users as $user): ?>
          usernames.push('<?= addslashes($user['username']) ?>');
        <?php endforeach; ?>
      <?php endif; ?>

      if (usernames.length > 0) {
        // Open print page for all users
        var printWindow = window.open(
          'page/hotspot/print_all_tickets.php?usernames=' + encodeURIComponent(JSON.stringify(usernames)),
          'printAllTickets',
          'width=800,height=600,scrollbars=yes,resizable=yes'
        );

        // Focus on the new window
        if (printWindow) {
          printWindow.focus();
        }
      } else {
        alert('No users to print');
      }
    }
  </script>

<?php
} else {
  echo "Anda Tidak Berhak Mengakses Halaman Ini";
}
?>