<?php

function formatBytes($bytes)
{
  $units = array('B', 'KB', 'MB', 'GB', 'TB');
  $bytes = max($bytes, 0);
  $pow = floor(($bytes ? log($bytes) : log(1024)));
  $pow = min($pow, count($units) - 1);

  $bytes /= (1 << (10 * $pow));

  return round($bytes, 2) . ' ' . $units[$pow];
}

session_start();
if (isset($_SESSION['admin']) || $_SESSION['teknisi'] == true) {

  // Handle batch delete action
  if (isset($_POST['batch_delete_action']) && isset($_POST['selected_users'])) {
    $selected_users = $_POST['selected_users'];
    $deleted_count = 0;
    $failed_count = 0;
    $error_messages = array();

    // Connect to MikroTik
    $sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
    $result = mysqli_query($koneksi, $sql_mikrotik);
    $row = mysqli_fetch_assoc($result);

    $API = new RouterosAPI();

    if ($API->connect($row['ip'], $row['username'], $row['password'])) {
      foreach ($selected_users as $username) {
        try {
          // Find the user first
          $user_found = $API->comm("/ip/hotspot/user/print", array(
            "?name" => $username
          ));

          if (!empty($user_found)) {
            // Delete the user
            $delete_result = $API->comm("/ip/hotspot/user/remove", array(
              ".id" => $user_found[0]['.id']
            ));

            // Check if deletion was successful
            if (empty($delete_result) || !isset($delete_result[0]['!trap'])) {
              $deleted_count++;
            } else {
              $failed_count++;
              $error_messages[] = "Failed to delete $username: " . ($delete_result[0]['=message'] ?? 'Unknown error');
            }
          } else {
            $failed_count++;
            $error_messages[] = "User '$username' not found!";
          }
        } catch (Exception $e) {
          $failed_count++;
          $error_messages[] = "Error deleting $username: " . $e->getMessage();
        }
      }
      $API->disconnect();
    } else {
      $error_message = "Failed to connect to MikroTik router!";
    }

    // Set success/error messages
    if ($deleted_count > 0) {
      $success_message = "Successfully deleted $deleted_count user(s).";
      if ($failed_count > 0) {
        $success_message .= " Failed to delete $failed_count user(s).";
      }
    } else {
      $error_message = "Failed to delete any users. " . implode(' ', $error_messages);
    }
  }

  // Handle delete user action
  if (isset($_POST['delete_user_action']) && isset($_POST['delete_username'])) {
    $username_to_delete = $_POST['delete_username'];

    // Connect to MikroTik
    $sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
    $result = mysqli_query($koneksi, $sql_mikrotik);
    $row = mysqli_fetch_assoc($result);

    $API = new RouterosAPI();

    if ($API->connect($row['ip'], $row['username'], $row['password'])) {
      try {
        // Find the user first
        $user_found = $API->comm("/ip/hotspot/user/print", array(
          "name" => $username_to_delete
        ));

        if (!empty($user_found)) {
          // Delete the user
          $delete_result = $API->comm("/ip/hotspot/user/remove", array(
            ".id" => $user_found[0]['.id']
          ));

          // Check if deletion was successful
          if (empty($delete_result) || !isset($delete_result[0]['!trap'])) {
            $success_message = "User '$username_to_delete' has been deleted successfully!";
          } else {
            $error_message = "Failed to delete user: " . ($delete_result[0]['=message'] ?? 'Unknown error');
          }
        } else {
          $error_message = "User '$username_to_delete' not found!";
        }
      } catch (Exception $e) {
        $error_message = "Error deleting user: " . $e->getMessage();
      }

      $API->disconnect();
    } else {
      $error_message = "Failed to connect to MikroTik router!";
    }
  }
?>

  <?php
  $sql_mikrotik = "SELECT * FROM tbl_mikrotik WHERE id_mikrotik = 1";
  $result = mysqli_query($koneksi, $sql_mikrotik);
  $row = mysqli_fetch_assoc($result);

  $API = new RouterosAPI();

  // var_dump([$row['ip'], $row['username'], $row['password']]);
  // exit;
  if ($connection_status = $API->connect($row['ip'], $row['username'], $row['password'])) {
    // var_dump($connection_status);
    // exit;
    $s = $API->comm("/ip/hotspot/user/print");

    // Get hotspot user profiles to show rate limits
    $profiles = $API->comm("/ip/hotspot/user/profile/print");
    $profile_rates = array();

    // Create a lookup array for profile rate limits
    foreach ($profiles as $profile) {
      $profile_rates[$profile['name']] = array(
        'rate-limit' => isset($profile['rate-limit']) ? $profile['rate-limit'] : 'N/A'
      );
    }
  ?>

    <div class="row">

      <div class="col-md-12">
        <!-- Advanced Tables -->
        <div class="box box-primary box-solid">
          <div class="box-header with-border">
            <b>Users Hotspot</b> &nbsp; | &nbsp;
            <!-- <a href="?page=users-hotspot&aksi=add_users"> <b><i class="fa fa-user-plus" aria-hidden="true"></i> Add Users</b></a>
            &nbsp; | &nbsp; -->
            <a href="?page=users-hotspot&aksi=generate_users"> <b><i class="fa fa-users" aria-hidden="true"></i> Generate </b></a>
            &nbsp; | &nbsp;
            <a href="?page=users-profile"> <b><i class="fa fa-list" aria-hidden="true"></i> List Profile </b></a>
            &nbsp; | &nbsp;
            <button type="button" class="btn btn-danger btn-sm" onclick="batchDelete()" id="batchDeleteBtn" style="display: none;">
              <i class="fa fa-trash"></i> Delete Selected
            </button>
          </div>

          <!-- Success/Error Messages -->
          <?php if (isset($success_message)): ?>
            <div class="alert alert-success alert-dismissible">
              <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
              <i class="fa fa-check"></i> <?= htmlspecialchars($success_message) ?>
            </div>
          <?php endif; ?>

          <?php if (isset($error_message)): ?>
            <div class="alert alert-danger alert-dismissible">
              <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
              <i class="fa fa-exclamation-triangle"></i> <?= htmlspecialchars($error_message) ?>
            </div>
          <?php endif; ?>
          <div class="panel-body">
            <form id="batchDeleteForm" method="POST">
              <input type="hidden" name="batch_delete_action" value="1">
              <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover" id="example1">
                  <thead>
                    <tr>
                      <th style="width: 30px;">
                        <input type="checkbox" id="selectAll" onchange="toggleSelectAll()">
                      </th>
                      <th>Aksi</th>
                      <th>No</th>
                      <th>Name</th>
                      <th>Profile</th>
                      <th>Rate Limit</th>
                      <th>Up Time</th>
                      <th>Bytes In</th>
                      <th>Bytes Out</th>
                      <th>Comment</th>
                      <th>Print</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $i = 1;
                    foreach ($s as $p) :
                      $rate_limit = isset($profile_rates[$p['profile']]) ? $profile_rates[$p['profile']]['rate-limit'] : 'N/A';
                    ?>
                      <tr>
                        <td style='text-align:center;'>
                          <input type="checkbox" class="user-checkbox" name="selected_users[]" value="<?= htmlspecialchars($p['name']) ?>" onchange="updateBatchDeleteButton()">
                        </td>
                        <td style='text-align:center;'>
                          <!-- DELETE BUTTON -->
                          <a href="#" onclick="deleteUserAjax('<?= htmlspecialchars($p['name']) ?>')" title="Delete User">
                            <i class='fa fa-trash text-danger pointer'></i>
                          </a>
                        </td>
                        <td><?= $i++ ?></td>
                        <td><?= $p['name'] ?></td>
                        <td><?= $p['profile'] ?></td>
                        <td><?= $rate_limit ?></td>
                        <td><?= ($p['uptime'] == '0s') ? '00:00:00' : ($p['uptime']) ?></td>
                        <td><?= formatBytes($p['bytes-in']) ?></td>
                        <td><?= formatBytes($p['bytes-out']) ?></td>
                        <td><?= $p['comment'] ?></td>
                        <td style='text-align:center;'>
                          <button class="btn btn-xs btn-success" onclick="printTicket('<?= htmlspecialchars($p['name']) ?>')" title="Print Ticket">
                            <i class='fa fa-print'></i> Print
                          </button>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

  <?php }
  $API->disconnect();
  ?>

  <script>
    function printTicket(username) {
      // Open print page in new window
      var printWindow = window.open(
        'page/hotspot/print_ticket.php?username=' + encodeURIComponent(username),
        'printTicket',
        'width=400,height=600,scrollbars=yes,resizable=yes'
      );

      // Focus on the new window
      if (printWindow) {
        printWindow.focus();
      }
    }

    function deleteUser(username) {
      if (confirm('Are you sure you want to delete user "' + username + '"? This action cannot be undone.')) {
        // Show loading
        var loadingHtml = '<i class="fa fa-spinner fa-spin"></i> Deleting...';

        // Create form and submit
        var form = document.createElement('form');
        form.method = 'POST';
        form.style.display = 'none';

        var usernameInput = document.createElement('input');
        usernameInput.type = 'hidden';
        usernameInput.name = 'delete_username';
        usernameInput.value = username;

        var actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'delete_user_action';
        actionInput.value = '1';

        form.appendChild(usernameInput);
        form.appendChild(actionInput);
        document.body.appendChild(form);
        form.submit();
      }
    }

    // Enhanced AJAX version for better UX (optional)
    function deleteUserAjax(username) {
      if (confirm('Are you sure you want to delete user "' + username + '"? This action cannot be undone.')) {
        // Show loading state
        var deleteBtn = event.target.closest('a');
        var originalText = deleteBtn.innerHTML;
        deleteBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Deleting...';
        deleteBtn.disabled = true;

        // Create form data
        const formData = new FormData();
        formData.append('username', username);

        // Use fetch API
        fetch('page/hotspot/users_hotspot/delete_user.php', {
            method: 'POST',
            body: formData
          })
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok');
            }
            return response.json();
          })
          .then(data => {
            if (data.success) {
              // Show success message
              showMessage('success', data.message);
              // Remove the row from table with animation
              deleteBtn.closest('tr').style.opacity = '0.5';
              setTimeout(() => {
                deleteBtn.closest('tr').remove();
              }, 1000);
            } else {
              // Show error message
              showMessage('error', data.message);
              // Restore button
              deleteBtn.innerHTML = originalText;
              deleteBtn.disabled = false;
            }
          })
          .catch(error => {
            console.error('Error:', error);
            showMessage('error', 'Error deleting user: ' + error.message);
            // Restore button
            deleteBtn.innerHTML = originalText;
            deleteBtn.disabled = false;
          });
      }
    }

    function showMessage(type, message) {
      var alertClass = (type === 'success') ? 'alert-success' : 'alert-danger';
      var iconClass = (type === 'success') ? 'fa-check' : 'fa-exclamation-triangle';

      var messageHtml = '<div class="alert ' + alertClass + ' alert-dismissible" style="margin: 10px;">' +
        '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
        '<i class="fa ' + iconClass + '"></i> ' + message +
        '</div>';

      // Insert message at the top of content
      var contentArea = document.querySelector('.content-wrapper .content');
      if (contentArea) {
        contentArea.insertAdjacentHTML('afterbegin', messageHtml);

        // Auto-hide after 5 seconds
        setTimeout(function() {
          var alertDiv = contentArea.querySelector('.alert');
          if (alertDiv) {
            alertDiv.remove();
          }
        }, 5000);
      }
    }

    // Batch delete functions
    function toggleSelectAll() {
      var selectAll = document.getElementById('selectAll');
      var checkboxes = document.querySelectorAll('.user-checkbox');

      checkboxes.forEach(function(checkbox) {
        checkbox.checked = selectAll.checked;
      });

      updateBatchDeleteButton();
    }

    function updateBatchDeleteButton() {
      var checkboxes = document.querySelectorAll('.user-checkbox:checked');
      var batchDeleteBtn = document.getElementById('batchDeleteBtn');

      if (checkboxes.length > 0) {
        batchDeleteBtn.style.display = 'inline-block';
        batchDeleteBtn.innerHTML = '<i class="fa fa-trash"></i> Delete Selected (' + checkboxes.length + ')';
      } else {
        batchDeleteBtn.style.display = 'none';
      }
    }

    function batchDelete() {
      var checkboxes = document.querySelectorAll('.user-checkbox:checked');

      if (checkboxes.length === 0) {
        alert('Please select users to delete.');
        return;
      }

      var usernames = [];
      checkboxes.forEach(function(checkbox) {
        usernames.push(checkbox.value);
      });

      if (confirm('Are you sure you want to delete ' + usernames.length + ' selected user(s)? This action cannot be undone.\n\nUsers: ' + usernames.join(', '))) {
        document.getElementById('batchDeleteForm').submit();
      }
    }
  </script>

<?php
} else {
  echo "Anda Tidak Berhak Mengakses Halaman Ini";
}
?>