<?php

require_once dirname(__FILE__) . '/PaymentGatewayFactory.php';
include("../include/koneksi.php");

// Get payment gateway configuration
$queryP = $koneksi->query("SELECT * FROM tbl_pgate LIMIT 1");
$tokenP = $queryP->fetch_assoc();

if (!$tokenP || empty($tokenP['provider'])) {
  die("Error: Payment gateway not configured properly.");
}

$provider = $tokenP['provider'];
$name = $_POST['name_user'];
$id_tagihan = $_POST['id_tagihan'];
$harga = $_POST['harga'];
$nama_paket = $_POST['nama_paket'];
$telp = $_POST['no_telp'];
$paymentChannel = $_POST['payment_channel'] ?? null; // For Tripay payment method

// Prepare transaction parameters
$orderId = $id_tagihan . '-' . time();
$transactionParams = [
  'order_id' => $orderId,
  'gross_amount' => $harga,
  'item_id' => $id_tagihan,
  'item_name' => $nama_paket,
  'customer_name' => $name,
  'customer_phone' => $telp,
  'customer_email' => 'customer@example.com', // Default email
  'payment_channel' => $paymentChannel // Add payment channel for Tripay
];

try {
  // Create payment gateway instance
  $paymentGateway = PaymentGatewayFactory::create($provider, $tokenP);

  // Create transaction
  $transactionData = $paymentGateway->createTransaction($transactionParams);

  // var_dump($transactionData); // Debugging line to inspect transaction data
  // exit(); // Uncomment this line if you want to stop execution after debugging

  // Save order ID to database for tracking
  $paymentChannelDb = $paymentChannel ? $paymentChannel : $provider;
  $result = $koneksi->query("UPDATE tb_tagihan SET 
        provider='$provider',
        order_id='$orderId'
        WHERE id_tagihan='$id_tagihan'");
  // Get redirect URL
  $paymentUrl = $paymentGateway->getRedirectUrl($transactionData);

  if ($paymentUrl) {
    // Redirect to payment page
    header('Location: ' . $paymentUrl);
    exit();
  } else {
    echo "Error: Unable to create payment URL";
  }
} catch (\Exception $e) {
  echo "Payment Error: " . $e->getMessage();
}
